@extends('layouts/contentLayoutMaster')

@section('title', 'OffCanvas')

@section('content')
<!-- Basic Offcanvas -->
<section id="basic-offcanvas">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Offcanvas Placements</h4>
        </div>
        <div class="card-body">
          <div class="demo-inline-spacing">
            <!-- Basic Offcanvas -->
            <div class="offcanvas-start-example">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasStart"
                aria-controls="offcanvasStart"
              >
                Toggle Start
              </button>
              <div
                class="offcanvas offcanvas-start"
                tabindex="-1"
                id="offcanvasStart"
                aria-labelledby="offcanvasStartLabel"
              >
                <div class="offcanvas-header">
                  <h5 id="offcanvasStartLabel" class="offcanvas-title">Offcanvas Start</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body my-auto mx-0 flex-grow-0">
                  <p class="text-center">
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary mb-1 d-grid w-100">Continue</button>
                  <button type="button" class="btn btn-outline-secondary d-grid w-100" data-bs-dismiss="offcanvas">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
            <!-- Basic offcanvas end -->

            <!-- End Offcanvas -->
            <div class="offcanvas-end-example">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasEnd"
                aria-controls="offcanvasEnd"
              >
                Toggle End
              </button>
              <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasEnd" aria-labelledby="offcanvasEndLabel">
                <div class="offcanvas-header">
                  <h5 id="offcanvasEndLabel" class="offcanvas-title">Offcanvas End</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body my-auto mx-0 flex-grow-0">
                  <p class="text-center">
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary mb-1 d-grid w-100">Continue</button>
                  <button type="button" class="btn btn-outline-secondary d-grid w-100" data-bs-dismiss="offcanvas">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
            <!--/ End Offcanvas-->

            <!-- Top Offcanvas -->
            <div class="offcanvas-top-example">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasTop"
                aria-controls="offcanvasTop"
              >
                Toggle Top
              </button>
              <div class="offcanvas offcanvas-top" tabindex="-1" id="offcanvasTop" aria-labelledby="offcanvasTopLabel">
                <div class="offcanvas-header">
                  <h5 id="offcanvasTopLabel" class="offcanvas-title">Offcanvas Top</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body">
                  <p>
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary me-1">Continue</button>
                  <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
                </div>
              </div>
            </div>
            <!-- Top Offcanvas end-->

            <!-- Bottom Offcanvas -->
            <div class="offcanvas-bottom-example">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasBottom"
                aria-controls="offcanvasBottom"
              >
                Toggle Bottom
              </button>
              <div
                class="offcanvas offcanvas-bottom"
                tabindex="-1"
                id="offcanvasBottom"
                aria-labelledby="offcanvasBottomLabel"
              >
                <div class="offcanvas-header">
                  <h5 id="offcanvasBottomLabel" class="offcanvas-title">Offcanvas Bottom</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body">
                  <p>
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary me-1">Continue</button>
                  <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
                </div>
              </div>
            </div>
            <!-- Bottom Offcanvas end-->
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!--/ Basic Offcanvas -->

<!-- Basic Offcanvas -->
<section id="basic-offcanvas">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Backdrop</h4>
        </div>
        <div class="card-body">
          <div class="demo-inline-spacing">
            <!-- Enable Body Scrolling -->
            <div class="enable-body-scrolling">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasScroll"
                aria-controls="offcanvasScroll"
              >
                Enable Body Scrolling
              </button>
              <div
                class="offcanvas offcanvas-end"
                data-bs-scroll="true"
                data-bs-backdrop="false"
                tabindex="-1"
                id="offcanvasScroll"
                aria-labelledby="offcanvasScrollLabel"
              >
                <div class="offcanvas-header">
                  <h5 id="offcanvasScrollLabel" class="offcanvas-title">Offcanvas Scroll</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body my-auto mx-0 flex-grow-0">
                  <p class="text-center">
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary mb-1 d-grid w-100">Continue</button>
                  <button type="button" class="btn btn-outline-secondary d-grid w-100" data-bs-dismiss="offcanvas">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
            <!--/ Enable Body Scrolling -->

            <!-- Enable backdrop (default) -->
            <div class="enable-backdrop">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasBackdrop"
                aria-controls="offcanvasBackdrop"
              >
                Enable Backdrop
              </button>
              <div
                class="offcanvas offcanvas-end"
                tabindex="-1"
                id="offcanvasBackdrop"
                aria-labelledby="offcanvasBackdropLabel"
              >
                <div class="offcanvas-header">
                  <h5 id="offcanvasBackdropLabel" class="offcanvas-title">Enable backdrop</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body my-auto mx-0 flex-grow-0">
                  <p class="text-center">
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary mb-1 d-grid w-100">Continue</button>
                  <button type="button" class="btn btn-outline-secondary d-grid w-100" data-bs-dismiss="offcanvas">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
            <!--/ Enable backdrop (default) -->

            <!-- Enable Scrolling & Backdrop -->
            <div class="enable-scrolling-backdrop">
              <button
                class="btn btn-outline-primary"
                type="button"
                data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasBoth"
                aria-controls="offcanvasBoth"
              >
                Enable Both Scrolling & Backdrop
              </button>
              <div
                class="offcanvas offcanvas-end"
                data-bs-scroll="true"
                tabindex="-1"
                id="offcanvasBoth"
                aria-labelledby="offcanvasBothLabel"
              >
                <div class="offcanvas-header">
                  <h5 id="offcanvasBothLabel" class="offcanvas-title">Enable both scrolling & backdrop</h5>
                  <button
                    type="button"
                    class="btn-close text-reset"
                    data-bs-dismiss="offcanvas"
                    aria-label="Close"
                  ></button>
                </div>
                <div class="offcanvas-body my-auto mx-0 flex-grow-0">
                  <p class="text-center">
                    Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or
                    web designs. The passage is attributed to an unknown typesetter in the 15th century who is thought
                    to have scrambled parts of Cicero's De Finibus Bonorum et Malorum for use in a type specimen book.
                  </p>
                  <button type="button" class="btn btn-primary mb-1 d-grid w-100">Continue</button>
                  <button type="button" class="btn btn-outline-secondary d-grid w-100" data-bs-dismiss="offcanvas">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
            <!--/ Enable Scrolling & Backdrop -->
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Basic Offcanvas end -->
@endsection
