@extends('layouts/contentLayoutMaster')

@section('title', 'Buttons')

@section('content')
<!-- Filled Buttons start -->
<section id="basic-buttons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Filled</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">
            Bootstrap includes six predefined button styles, each serving its own semantic purpose.
          </p>
          <!-- basic buttons -->
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-primary">Primary</button>
            <button type="button" class="btn btn-secondary">Secondary</button>
            <button type="button" class="btn btn-success">Success</button>
            <button type="button" class="btn btn-danger">Danger</button>
            <button type="button" class="btn btn-warning">Warning</button>
            <button type="button" class="btn btn-info">Info</button>
            <button type="button" class="btn btn-dark">Dark</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Filled Buttons end -->

<!-- Outline Buttons start -->
<section id="outline-button">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Border</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">
            Use a class <code>.btn-outline-{color}</code> to quickly create a outline button.
          </p>
          <!-- Outline buttons -->
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-outline-primary">Primary</button>
            <button type="button" class="btn btn-outline-secondary">Secondary</button>
            <button type="button" class="btn btn-outline-success">Success</button>
            <button type="button" class="btn btn-outline-danger">Danger</button>
            <button type="button" class="btn btn-outline-warning">Warning</button>
            <button type="button" class="btn btn-outline-info">Info</button>
            <button type="button" class="btn btn-outline-dark">Dark</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Outline Buttons end -->

<!-- Flat Buttons start -->
<section id="flat-buttons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Flat</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">Use <code>.btn-flat-{color}</code> to create a flat button</p>
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-flat-primary">Primary</button>
            <button type="button" class="btn btn-flat-secondary">Secondary</button>
            <button type="button" class="btn btn-flat-success">Success</button>
            <button type="button" class="btn btn-flat-danger">Danger</button>
            <button type="button" class="btn btn-flat-warning">Warning</button>
            <button type="button" class="btn btn-flat-info">Info</button>
            <button type="button" class="btn btn-flat-dark">Dark</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Flat Buttons end -->

<!-- Gradient Buttons Start -->
<section id="gradient-buttons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Gradient</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">use <code>btn-gradient-{color}</code> create gradient buttons</p>
          <!-- basic buttons -->
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-gradient-primary">Primary</button>
            <button type="button" class="btn btn-gradient-secondary">Secondary</button>
            <button type="button" class="btn btn-gradient-success">Success</button>
            <button type="button" class="btn btn-gradient-danger">Danger</button>
            <button type="button" class="btn btn-gradient-warning">Warning</button>
            <button type="button" class="btn btn-gradient-info">Info</button>
            <button type="button" class="btn btn-gradient-dark">Dark</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Gradient Buttons End -->

<!-- Relief Buttons start -->
<section id="relief-buttons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Relief</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">Use <code>.btn-relief-{color}</code> to create a relief button.</p>
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-relief-primary">Primary</button>
            <button type="button" class="btn btn-relief-secondary">Secondary</button>
            <button type="button" class="btn btn-relief-success">Success</button>
            <button type="button" class="btn btn-relief-danger">Danger</button>
            <button type="button" class="btn btn-relief-warning">Warning</button>
            <button type="button" class="btn btn-relief-info">Info</button>
            <button type="button" class="btn btn-relief-dark">Dark</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Relief Buttons end -->

<!-- Round Buttons start -->
<section id="round-outline-button">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Round buttons</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">
            Use a class <code>.round</code> with outline button class to create round outline button.
          </p>
          <!-- Round buttons -->
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-outline-primary round">Primary</button>
            <button type="button" class="btn btn-outline-secondary round">Secondary</button>
            <button type="button" class="btn btn-outline-success round">Success</button>
            <button type="button" class="btn btn-outline-danger round">Danger</button>
            <button type="button" class="btn btn-outline-warning round">Warning</button>
            <button type="button" class="btn btn-outline-info round">Info</button>
            <button type="button" class="btn btn-outline-dark round">Dark</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Round Buttons end -->

<!-- Basic Button Icon start -->
<section id="basic-button-icons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Icon</h4>
        </div>
        <div class="card-body">
          <!-- Buttons with Icon -->
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-outline-primary">
              <i data-feather="home" class="me-25"></i>
              <span>Home</span>
            </button>
            <button type="button" class="btn btn-warning">
              <i data-feather="star" class="me-25"></i>
              <span>Star</span>
            </button>
            <button type="button" class="btn btn-flat-success">
              <i data-feather="check" class="me-25"></i>
              <span>Done</span>
            </button>
            <button type="button" class="btn btn-outline-primary" disabled>
              <i data-feather="home" class="me-25"></i>
              <span>Home</span>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Basic Button Icon end -->

<!-- Icon Buttons start -->
<section id="icon-only-buttons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Icon Only</h4>
        </div>
        <div class="card-body">
          <p class="card-text mb-0">
            You can use <code>.btn-icon</code>. you can create a rounded button by using
            <code>.rounded-circle</code> with <code>.btn-icon</code>. You can only use <code>.btn-icon</code> when you
            only want icon in your button
          </p>
          <div class="demo-inline-spacing">
            <button type="button" class="btn btn-icon btn-outline-primary">
              <i data-feather="search"></i>
            </button>
            <button type="button" class="btn btn-icon btn-warning">
              <i data-feather="inbox"></i>
            </button>
            <button type="button" class="btn btn-icon btn-flat-success">
              <i data-feather="camera"></i>
            </button>
            <button type="button" class="btn btn-icon btn-outline-primary" disabled>
              <i data-feather="search"></i>
            </button>
            <button type="button" class="btn btn-icon rounded-circle btn-outline-primary">
              <i data-feather="search"></i>
            </button>
            <button type="button" class="btn btn-icon btn-icon rounded-circle btn-warning">
              <i data-feather="inbox"></i>
            </button>
            <button type="button" class="btn btn-icon btn-icon rounded-circle btn-flat-success">
              <i data-feather="camera"></i>
            </button>
            <button type="button" class="btn btn-icon btn-icon rounded-circle btn-outline-primary" disabled>
              <i data-feather="search"></i>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Icon Buttons end -->

<!-- Basic Button group start -->
<section id="basic-button-group">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Basic Button group</h4>
        </div>
        <div class="card-body">
          <p class="card-text">
            Group a series of buttons together on a single line with the button group. Wrap a series of buttons with
            <code>.btn</code> in <code>.btn-group</code>.
          </p>
          <!-- button group -->
          <div class="row">
            <div class="col-lg-6 col-12 mb-1 mb-lg-0">
              <div class="btn-group" role="group" aria-label="Basic example">
                <button type="button" class="btn btn-primary">Left</button>
                <button type="button" class="btn btn-primary">Middle</button>
                <button type="button" class="btn btn-primary">Right</button>
              </div>
            </div>
            <div class="col-lg-6 col-12">
              <div class="btn-group" role="group" aria-label="Basic example">
                <button type="button" class="btn btn-outline-primary"><i data-feather="facebook"></i></button>
                <button type="button" class="btn btn-outline-primary"><i data-feather="twitter"></i></button>
                <button type="button" class="btn btn-outline-primary"><i data-feather="instagram"></i></button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Basic Button group end -->

<!-- Button group checkbox & radio start -->
<section id="checkbox-radio-button-group">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Checkbox & radio group</h4>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-lg-6 col-12 mb-1 mb-lg-0">
              <!-- button group checkbox -->
              <div class="btn-group" role="group" aria-label="Basic checkbox toggle button group">
                <input type="checkbox" class="btn-check" id="btncheck1" checked autocomplete="off" />
                <label class="btn btn-primary" for="btncheck1">Active</label>

                <input type="checkbox" class="btn-check" id="btncheck2" autocomplete="off" />
                <label class="btn btn-primary" for="btncheck2">Checkbox</label>

                <input type="checkbox" class="btn-check" id="btncheck3" autocomplete="off" />
                <label class="btn btn-primary" for="btncheck3">Checkbox</label>
              </div>
            </div>
            <div class="col-lg-6 col-12">
              <!-- button group radio -->
              <div class="btn-group" role="group" aria-label="Basic radio toggle button group">
                <input type="radio" class="btn-check" name="btnradio" id="btnradio1" autocomplete="off" checked />
                <label class="btn btn-outline-primary" for="btnradio1">Active</label>

                <input type="radio" class="btn-check" name="btnradio" id="btnradio2" autocomplete="off" />
                <label class="btn btn-outline-primary" for="btnradio2">Radio</label>

                <input type="radio" class="btn-check" name="btnradio" id="btnradio3" autocomplete="off" />
                <label class="btn btn-outline-primary" for="btnradio3">Radio</label>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Button group checkbox & radio end -->

<!-- Sizes start -->
<section id="sizes-2">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Sizes</h4>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-md-6 col-sm-12 mb-1 mb-md-0">
              <p class="card-text mb-0">
                Add <code>.btn-lg</code> or <code>.btn-sm</code> for Fancy larger or smaller buttons size.
              </p>
              <!-- simple sizes -->
              <div class="demo-inline-spacing">
                <button type="button" class="btn btn-primary btn-lg">Large</button>
                <button type="button" class="btn btn-primary">Default</button>
                <button type="button" class="btn btn-primary btn-sm">Small</button>
              </div>
            </div>
            <div class="col-md-6 col-sm-12">
              <p class="card-text mb-0">
                Add <code>.btn-lg</code> or <code>.btn-sm</code> with <code>.btn-outline-*</code> for outline btn in
                different sizes
              </p>
              <div class="demo-inline-spacing">
                <button type="button" class="btn btn-outline-primary btn-lg">Large</button>
                <button type="button" class="btn btn-outline-primary">Default</button>
                <button type="button" class="btn btn-outline-primary btn-sm">Small</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Sizes end -->

<!-- Block level buttons start -->
<section id="block-level-buttons">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Block level buttons</h4>
        </div>
        <div class="card-body">
          <p class="card-text">Create block level buttons with a mix of our display and gap utilities.</p>
          <div class="row">
            <div class="d-grid col-lg-6 col-md-12 mb-1 mb-lg-0">
              <button type="button" class="btn btn-primary">Block level button</button>
            </div>
            <div class="d-grid col-lg-6 col-md-12">
              <button type="button" class="btn btn-outline-primary">Block level button</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Block level buttons end -->

<!-- Button tags start -->
<section id="button-tags">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">Button tags</h4>
        </div>
        <div class="card-body">
          <!-- anchor, button tag, input button, input submit Tags -->
          <p class="card-text mb-0">
            The <code>.btn</code> classes are designed to be used with the <code>&lt;button&gt;</code> element. However,
            you can also use these classes on <code>&lt;a&gt;</code> or <code>&lt;input&gt;</code> elements.
          </p>
          <div class="demo-inline-spacing">
            <a class="btn btn-primary" href="https://pixinvent.com/" role="button" target="_blank">Link</a>
            <button class="btn btn-primary" type="submit">Button</button>
            <input class="btn btn-primary" type="button" value="Input" />
            <input class="btn btn-primary" type="submit" value="Submit" />
            <input class="btn btn-primary" type="reset" value="Reset" />
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Button tags end -->
@endsection
